#ifndef STRUKTURY_H
#define STRUKTURY_H

#include <QMutex>

#define arl 512                                                                 //maximální délka postfixu
#define char_ofest 1072                                                         //posunutí ascii

typedef double real;

struct black_hole_param {
    real M;                                                                     //hmotnost
    real a;                                                                     //spin
    real Q;                                                                     //náboj
    real Λ;                                                                     //kosmologická konstanta
    real i;                                                                     //vnitřní poloměr keplerova disku
    real o;                                                                     //vnější poloměr keplerova disku
};

struct f_vec {                                                                  //čtyřvektor
    real x[4];
    real& operator[](int index) { return x[index]; }                            //operátor přetypování
};

struct polar {                                                                  //polární souřadnice
    real r;
    real φ;
};

struct tr_pfx{
    uchar n[arl];                                                               //přeložený postfix
    bool no[5];                                                                 //příznak absence proměnné t,r,θ,φ pro zrychlení derivací
    uchar& operator[](int index) { return n[index]; }                           //operátor přetypování
};

struct tensor_2 {                                                               //přeložený tenzor g_{\mu\nu} a g^{\mu\nu}
    tr_pfx kov[4][4];
    tr_pfx kon[4][4];
    tr_pfx det;
};

struct tensor_3 {
    real a[4][4][4];
    real& operator()(int i, int j, int k) { return a[i][j][k]; }                //operátor přetypování
};

class geo {                                                                     //záznam bodů geodetiky (poloha, rychlost)
private:
    f_vec* xArray;
    f_vec* vArray;
    int count;
    int kapacita = 0;

public:
    geo();
    ~geo();

    void insert(const f_vec& xData, const f_vec& vData);
    f_vec getX(int index) const;
    f_vec getV(int index) const;
    int getCount() const;
};

class Counter                                                                   //počítadlo s mutexem pro vlákna
{
public:
    Counter();
    void increment();
    void decrement();
    int value() const;

private:
    mutable QMutex mutex;
    int n;
};

class MyImage                                                                   //objekt obrázku
{
public:
    MyImage(int width, int height);
    MyImage();
    ~MyImage();

    void dim(int width, int height);
    void set_pixel(int x, int y, uint32_t c);
    void set_done(int x, int y);
    void x(f_vec x);
    void v(f_vec v);
    uint32_t read(int x, int y) const;
    bool done(int x, int y) const;
    int done() const;
    int pixels() const;
    int width() const;
    int height() const;
    f_vec x() const;
    f_vec v() const;

private:
    mutable QMutex mutex;
    uint32_t* n;
    bool* d;
    uint w, h, count;
    f_vec loc, speed;
};

#endif // STRUKTURY_H
