#include "image_generate.h"                                                     //generování obrázku

#include <QtConcurrent/QtConcurrent>                                            //knihovna pro práci s vlákny a multitaskingem
#include "geodetics.h"                                                          //výpočty geodetiky a pomocí geodetiky
#include "numerics.h"                                                           //numerické metody

void ImgFree(void* buf) {uchar* p_im = (uchar*)buf; delete[] p_im;}             //čistící funkce pro QImage

QImage raw_to_image(MyImage &image, int width, int height, int w, int h)        //převod MyImage na QImage
{
    if (w == 0) w = width;
    if (h == 0) h = height;
    uchar* p_im = new uchar[w * h * 4 + 1];                                     //alokace paměti
    for (int i = 0, k = 0; i < height; ++i)
        for (int j = 0; j < width; ++j)
            if (image.done(j, i)) {                                             //načtení barvy z image
                uint col = image.read(j, i);
                p_im[4 * k    ] = *((uchar *)&col);                             //rozdělení na 4 bajty a zápis za sebou
                p_im[4 * k + 1] = *((uchar *)&col + 1);
                p_im[4 * k + 2] = *((uchar *)&col + 2);
                p_im[4 * k + 3] = *((uchar *)&col + 3);
                k++;
            }
    QImage img(p_im, w, h, QImage::Format_RGB32, ImgFree, p_im);                //převod alokované paměti na QImage a její uvolnění
    return img;                                                                 //slouží na převod dílčího stavu image na zobrazitelný
}

SetColor::SetColor(int &x, int &y, int &w, int &h, real &z, f_vec &sp,f_vec &rp)//konstruktor vlákna
: x(x), y(y), w(w), h(h), z(z), sp(sp), rp(rp) {}

void SetColor::run()                                                            //tělo vlákna
{
    image[frame].set_pixel(x, y, GetColor(z*(x-w/2.)/w, z*(y-h/2.)/w, sp, rp));
    num_thread.decrement();
}

void waitToFreeThread(int numUsedThread)                                        //čekání na uvolnění jednoho z vláken pro další výpočet
{
    while (num_thread.value() > numUsedThread && !stop)                         //ukončení čekání v případě ručního přerušení výpočtu
        QCoreApplication::processEvents();                                      //dávání prostoru zbytku aplikace při čekání
}

qint64 Compute(f_vec x_, f_vec v_, int w_, int h_, real ω_, Ui::MainWindow *ui)                             //výpočet jednoho snímku
{
    QThreadPool pool;
    int prgrs, l_prgrs = 0,
        max_t = QThread::idealThreadCount(),                                    //zjištění kolik vláken je na konkrétním počítači k dispozici
        deep = log(w_) / log(2) + 2;                                            //výpočet hloubky (počtu zpřesnění obrazu)
    real pom;
    QElapsedTimer timer;                                                        //vytvoření hodin
    pool.setMaxThreadCount(max_t);
    timer.start();                                                              //spuštění hodin
    image[frame].dim(w_, h_);                                                   //vytvoření prostoru snímku
    image[frame].x(x_);                                                         //zápis polohy pozorovatele
    image[frame].v(v_);                                                         //zápis rychlosti pozorovatele
    el_ab  = ui->checkBox_aber->isChecked();                                    //zda se má centrovat pohled na díru posunutou aberací
    shift  = ui->checkBox_redshift->isChecked();                                //zda se má započítat rudý posuv
    kepler = ui->checkBox_kepler->isChecked();                                  //zda se má uvažovat akreční disk
    beam   = ui->checkBox_beam->isChecked();                                    //zda se má uvažovat zjasnění beamingem
    simul  = ui->radioButton_sim->isChecked();                                  //který typ zobrazení červeného posuvu se použije
    for (int d = 6; d < deep && !stop; ++d) {                                   //vrstvy zlepšování rozlišení
        int p2d = pw(2, d);                                                     //začíná na 64x64 bodech
        for (int rw = 0; rw < p2d && !stop; ++rw) {                             //řádky obrazu
            int y = rw * h_ / p2d;
            for (int cl = 0; cl < p2d && !stop; ++cl) {                         //sloupce obrazu
                int x = cl * w_ / p2d;                                          //výpočet pozice bodu hrubého obrazu v obraze plného rozlišení
                if (!image[frame].done(x, y)) {                                 //když bod už není vypočtený, tak počítej
                    image[frame].set_done(x, y);                                //nastav, že tento bod už se počítá
                    waitToFreeThread(1024);                                     //čekej na volné vlákno pro GUI
                    num_thread.increment();                                     //zaber si vlákno
                    pool.start(new SetColor(x, y, w_, h_, ω_, x_, v_));
                }
            }
            pom = image[frame].pixels();
            pom /= image[frame].done();
            prgrs = 100 / pom;                                                  //vypočti stav zpracování jednoho snímku
            if (l_prgrs - prgrs) {                                              //když se změnil, předej ho k zobrazení na "teploměru"
                ui->progressBar->setValue(l_prgrs = prgrs);
                ui->lab_est_time->setText(to_time(timer.elapsed() * (pom - 1)));
            }
        }
        pool.waitForDone();                                                     //čekej až se dopočítají všechna vlákna
        int w = 0, h = 0;
        for (int i = 0; i < w_; ++i) if (image[frame].done(i, 0)) w++;          //spočti dílčí šířku obrazu
        for (int i = 0; i < h_; ++i) if (image[frame].done(0, i)) h++;          //spočti dilčí výšku obrazu
        QPixmap pixmap(w,h);                                                    //vytvoř dílčí bitmapu pro zobrazení
        pixmap.convertFromImage(raw_to_image(image[frame],w_,h_,w,h));
        pixmap = pixmap.scaled(w_, h_,
            Qt::IgnoreAspectRatio,Qt::SmoothTransformation);
        if (!stop)
            ui->label_screen->setPixmap(addTxtImg(pixmap.scaled(ui->label_screen
            ->size(),Qt::KeepAspectRatioByExpanding,Qt::SmoothTransformation),
            image[frame]));                                                     //když nebyl výpočet přerušen, zobraz dílčí obrázek, aby se nezobrazil rozpracovaný
    }
    return timer.elapsed();                                                     //vrať čas, jak dlouho trval jeden obrázek pro výpočet trvání celé animace
}
